require 'sketchup' # First we pull in the standard API hooks.
require 'ShaDe//lib//utils.rb'
require 'ShaDe//lib//geometry.rb'
require 'ShaDe//lib//data-structures.rb'
require 'ShaDe//lib//main-structures.rb'

#Author:: Manuela Ruiz  (mailto:mruiz@lcc.uma.es)
#This class represents the observer for the layers
class ShaDeLayersObserver < Sketchup::LayersObserver
	
	#Method that triggers when the current active layer is changed
	def onCurrentLayerChanged(layers, layer)
		#If layer does not exist...
		if !Shade.project.execution.current_shape.p[layer.name]

			Shade.project.modifying = true

			# Draw vertical line
			point1 = Constants::PTS_V[0].clone
			point2 = Constants::PTS_V[1].clone
			group = Sketchup.active_model.entities.add_group
			group.entities.add_line point1,point2
			group.layer = layer
			
			#Update the rules
			Shade.project.execution.grammar.rules.each_with_index { |rule, i|
				
				#Choose first non-empty layer
				found = false
				j = 0
				n_layers = Sketchup.active_model.layers.length
				layer_name = "Layer0"
				
				#The content of the new layer is the same that is inside the first non-empty layer in the left shape of the rule
				while (!found and (j < n_layers))
					layer_name = Sketchup.active_model.layers[j].name
					
					if rule.alpha.p[layer_name]
						found = (rule.alpha.p[layer_name].size > 0)
					end
					
					j += 1
				end
				
				if !(rule.left.s[layer.name])
					rule.left.s[layer.name] = rule.left.s[layer_name].clone
					rule.left.p[layer.name] = rule.left.p[layer_name].clone
					rule.left.paint()
				end
				
				if !(rule.right.s[layer.name])
					rule.right.s[layer.name] = rule.right.s[layer_name].clone
					rule.right.p[layer.name] = rule.right.p[layer_name].clone
					rule.right.paint()
				end

				#Paint the rule layout (arrow, crosses and horizontal line)
				ShadeUtils.paint_rule_layout(i, layer.name)
			}
			
			#Update the current shape
			#Choose first non-empty layer
			found = false
			j = 0
			n_layers = Sketchup.active_model.layers.length
			layer_name = "Layer0"
			#The content of the new layer is the same that is inside the first non-empty layer in the current_shape
			while (!found and (j < n_layers))
				layer_name = Sketchup.active_model.layers[j].name
				
				if Shade.project.execution.current_shape.p[layer_name]
					found = (Shade.project.execution.current_shape.p[layer_name].size > 0)
				end
				
				j += 1
			end

			Shade.project.execution.current_shape.s[layer.name] = Shade.project.execution.current_shape.s[layer_name].clone
			Shade.project.execution.current_shape.p[layer.name] = Shade.project.execution.current_shape.p[layer_name].clone
			Shade.project.execution.current_shape.create_pi

			Shade.project.execution.current_shape.paint(Shade.project.execution.show_labels, layer)
			
			#Update the axiom
			#Choose first non-empty layer
			found = false
			j = 0
			n_layers = Sketchup.active_model.layers.length
			layer_name = "Layer0"
			#The content of the new layer is the same that is inside the first non-empty layer in the current_shape
			while (!found and (j < n_layers))
				layer_name = Sketchup.active_model.layers[j].name
				
				if Shade.project.execution.grammar.axiom.p[layer_name]
					if Shade.project.execution.grammar.axiom.p[layer_name]
						found = (Shade.project.execution.grammar.axiom.p[layer_name].size > 0)
					end
				end
				
				j += 1
			end
			
			Shade.project.execution.grammar.axiom.s[layer.name] = Shade.project.execution.grammar.axiom.s[layer_name].clone
			Shade.project.execution.grammar.axiom.p[layer.name] = Shade.project.execution.grammar.axiom.p[layer_name].clone
			
			Shade.project.execution.grammar.saved = false
			
			Shade.project.modifying = false
		else
			#Update the rules
			Shade.project.execution.grammar.rules.each_with_index { |rule, i|
				rule.left.paint()
				rule.right.paint()
				#Paint the rule layout (arrow, crosses and horizontal line)
				ShadeUtils.paint_rule_layout(i, layer.name)
			}
			
			#Update the current shape
			Shade.project.execution.current_shape.paint(Shade.project.execution.show_labels)
		end
		
		
	end

	#Method that triggers then a layer is removed
	def onLayerRemoved(layers, layer)
		Shade.project.execution.grammar.rules.each { |rule|
			rule.left.s.delete layer.name
			rule.left.p.delete layer.name
			rule.left.shape_transformation.delete layer.name
			
			rule.right.s.delete layer.name
			rule.right.p.delete layer.name
			rule.left.shape_transformation.delete layer.name
		}
		Shade.project.execution.current_shape.s.delete layer.name
		Shade.project.execution.current_shape.p.delete layer.name
		
		Shade.project.execution.grammar.saved = false
	end
end
